package com.kongqw.serialportlibrary.thread;

import android.util.Log;

import com.kongqw.serialportlibrary.utils.ByteUtils;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by Kongqw on 2017/11/14.
 * Serial Message Reading Thread
 */

public abstract class SerialPortReadThread extends Thread {
    public abstract void onDataReceived(byte[] bytes);

    private InputStream mInputStream;
    private final byte[] mReadBuffer;
    public boolean isStopThread = false;
    private int type = 0;

    public SerialPortReadThread(InputStream inputStream, int type) {
        mInputStream = inputStream;
        mReadBuffer = new byte[1024];
        this.type = type;
    }

    @Override
    public void run() {
        super.run();
        if (type == 485) {
            Log.e("ReadThread", "type 485");
            while (!isStopThread) {
                try {
                    if (null == mInputStream) {
                        return;
                    }

                    Log.e("ReadThread", "type 1111");
                    int size = mInputStream.read(mReadBuffer);
                    Log.e("ReadThread size", size + "");
                    if (size <= 0) {
                        return;
                    }
                    Log.e("ReadThread", "type 2222");
                    byte[] readBytes = new byte[size];
                    System.arraycopy(mReadBuffer, 0, readBytes, 0, size);
                    onDataReceived(readBytes);
                    Log.e("ReadThread", "onDataReceived");
                } catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        } else {
            int rLen = 0;
            int dLen = 0;
            byte[] crc = new byte[]{0};
            byte[] tmp1 = new byte[]{0};
            byte[] tmp2 = new byte[]{0};

            while (!isStopThread) {
                try {
                    if (mInputStream == null) {
                        return;
                    }
                    if (!isHead()) {
                        continue;
                    }

                    crc[0] = 0x55;
                    crc[0] ^= 0xAA;
                    // cmd
                    rLen = recvBuffer(tmp1, 1, 600);
                    if (rLen != 1) {
                        continue;
                    }
                    crc[0] ^= tmp1[0];
                    if (tmp1[0] == 0x30) {
                        //Receive Data length
                        rLen = recvBuffer(tmp1, 1, 600);
                        if (rLen != 1) {
                            continue;
                        }
                        //Receive Data length
                        rLen = recvBuffer(tmp2, 1, 600);
                        if (rLen != 1) {
                            continue;
                        }
                        crc[0] ^= tmp1[0];
                        crc[0] ^= tmp2[0];
                        dLen = tmp1[0] & 0xff;
                        dLen |= ((tmp2[0] << 8) & 0xffff);
                        //dLen = ((uint)(tmp1[0])) | (tmp2[0] << 8);
                        byte[] data = new byte[dLen];
                        if (dLen > 0) {
                            rLen = recvBuffer(data, dLen, 600);
                            if (rLen != dLen) {
                                continue;
                            }
                        }
                        //Receive crc
                        rLen = recvBuffer(tmp1, 1, 600);
                        if (rLen != 1) {
                            continue;
                        }
                        for (int i = 0; i < dLen; i++) {
                            crc[0] ^= data[i];
                        }
                        //crc checksum
                        if (!ByteUtils.bytesToHexString(tmp1).equals(ByteUtils.bytesToHexString(crc))) {
                            continue;
                        }
                        onDataReceived(data);
                    } else {
                        Log.e("idhead", "no 0x30");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        }
    }

    public void startRead() {
        isStopThread = false;
        start();
    }


    public void stopRead() {
        isStopThread = true;
    }


    /**
     * Close the thread. Free up resources.
     */
    public void release() {
        stopRead();

        if (null != mInputStream) {
            try {
                mInputStream.close();
                mInputStream = null;
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int recvBuffer(byte[] buffer, int size, int msTimeout) {
        long stime = System.currentTimeMillis();
        int rLen = 0, offset = 0;
        byte[] rBuffer = new byte[1024];
        byte[] cache = new byte[1024];
        try {
            do {
                if (mInputStream.available() <= 0) {
                    Thread.sleep(10);
                    continue;
                }
                rLen = mInputStream.read(rBuffer, 0, Math.min(size, rBuffer.length));
                if (rLen <= 0) {
                    Thread.sleep(10);
                    continue;
                }
                stime = System.currentTimeMillis();

                if (offset + rLen > cache.length) {
                    byte[] tmp = new byte[offset];
                    System.arraycopy(cache, 0, tmp, 0, offset);
                    cache = new byte[(offset + rLen) * 2];
                    System.arraycopy(tmp, 0, cache, 0, offset);
                }
                System.arraycopy(rBuffer, 0, cache, offset, rLen);
                offset += rLen;
                if (offset >= size) {
                    System.arraycopy(cache, 0, buffer, 0, size);
                    break;
                }
            } while (msTimeout > 0 && System.currentTimeMillis() - stime < msTimeout);
        } catch (Exception e) {
            return offset;
        }
        return offset;
    }

    private boolean isHead() {
        byte[] head1 = new byte[]{0};
        byte[] head2 = new byte[]{0};

        while (true) {
            if (head1[0] != (byte) 0x55) {
                int rLen = recvBuffer(head1, 1, 500);
                if (rLen != 1) {
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        return false;
                    }
                    continue;
                }
            }

            int rLen = recvBuffer(head2, 1, 500);
            if (rLen != 1) {
                try {
                    Thread.sleep(10);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
                continue;
            }

            if (head1[0] != (byte) 0x55) {
                head1[0] = head2[0];
                continue;
            }
            if (head2[0] != (byte) 0xAA) {
                head1[0] = head2[0];
                continue;
            }
            return true;
        }
    }
}
